unit ParamList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFmParamList = class(TForm)
    lbParamSymbols: TListBox;
    btnSelect: TButton;
    btnCancel: TButton;
    lbParamNames: TListBox;
    rbParameterSymbol: TRadioButton;
    rbParameterName: TRadioButton;
    procedure btnSelectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure rbParameterSymbolClick(Sender: TObject);
    procedure rbParameterNameClick(Sender: TObject);
    procedure lbParamSymbolsClick(Sender: TObject);
    procedure lbParamNamesClick(Sender: TObject);
  private
    { Private declarations }
  public
    whichparselection: integer;
    { Public declarations }
  end;

var
  FmParamList: TFmParamList;

implementation
uses frontend, display, calculate, stypes;
{$R *.DFM}

procedure TFmParamList.FormCreate(Sender: TObject);
var
 i : integer;
begin
 // fill the boxes with names and symbols
 for i := 1 to modelDef.numparam do begin
  fmParamList.lbParamSymbols.Items.Add(par[i].symbol);
  fmParamList.lbParamNames.Items.Add(par[i].name);
 end;
 // select the first in the list
 fmParamList.lbParamSymbols.ItemIndex := 0;
 fmParamList.lbParamNames.ItemIndex := 0;

 // make sure the symbols box is on top
 fmParamList.lbParamSymbols.visible := true;
 fmParamList.lbParamNames.visible := false;

end;

procedure TFmParamList.btnSelectClick(Sender: TObject);
var
 tempString : string;
 tempIndex : integer;
 parameterSwitch : boolean;
begin

tempString := lbParamSymbols.items[lbParamSymbols.itemIndex];
tempIndex := fmCalculate.getArrayIndex(vtParameter,tempString);

// set the switch
parameterSwitch := true;

// which of the four labels in the display form was selected
case whichParSelection of
 1: begin
     // ensure you don't double select one parameter
     if (fmDisplayData.lblPar2.caption <> tempString) and
        (fmDisplayData.lblPar3.caption <> tempString) and
        (fmDisplayData.lblPar4.caption <> tempString)
     then begin
      fmDisplayData.lblPar1.caption := tempString;
      fmDisplayData.mePar1.text := floatToStr(par[tempIndex].value);
      fmDisplayData.mePar1.Enabled := true;
    //  parameterSwitch := true;
     end
     else begin
      messageDlg('That parameter is already displayed', mtWarning, [mbOK], 0);
      parameterSwitch := false;
     end;
    end;
 2: begin
     // ensure you don't double select one parameter
     if (fmDisplayData.lblPar1.caption <> tempString) and
        (fmDisplayData.lblPar3.caption <> tempString) and
        (fmDisplayData.lblPar4.caption <> tempString)
     then begin
      fmDisplayData.lblPar2.caption := tempString;
      fmDisplayData.mePar2.text := floatToStr(par[tempIndex].value);
      fmDisplayData.mePar2.Enabled := true;
     end
     else begin
      messageDlg('That parameter is already displayed', mtWarning, [mbOK], 0);
      parameterSwitch := false;
     end;
    end;
 3: begin
     // ensure you don't double select one parameter
     if (fmDisplayData.lblPar1.caption <> tempString) and
        (fmDisplayData.lblPar2.caption <> tempString) and
        (fmDisplayData.lblPar4.caption <> tempString)
     then begin
      fmDisplayData.lblPar3.caption := tempString;
      fmDisplayData.mePar3.text := floatToStr(par[tempIndex].value);
      fmDisplayData.mePar3.Enabled := true;
     end
     else begin
      messageDlg('That parameter is already displayed', mtWarning, [mbOK], 0);
      parameterSwitch := false;
     end;
    end;
 4: begin
     // ensure you don't double select one parameter
     if (fmDisplayData.lblPar1.caption <> tempString) and
        (fmDisplayData.lblPar2.caption <> tempString) and
        (fmDisplayData.lblPar3.caption <> tempString)
     then begin
      fmDisplayData.lblPar4.caption := tempString;
      fmDisplayData.mePar4.text := floatToStr(par[tempIndex].value);
      fmDisplayData.mePar4.Enabled := true;
     end
     else begin
      messageDlg('That parameter is already displayed', mtWarning, [mbOK], 0);
      parameterSwitch := false;
     end;
    end;
 else
    begin
     messageDlg('There`s a problem with the selection of a parameter',
      mtInformation, [mbOK], 0);
    end;
 end;
 // close this form
if parameterSwitch = true then fmParamList.ModalResult := 1;
end;

procedure TFmParamList.btnCancelClick(Sender: TObject);
begin
 // close this form
 fmParamList.ModalResult := 1;
end;

procedure TFmParamList.rbParameterSymbolClick(Sender: TObject);
begin
 // make sure the symbols box is on top
 fmParamList.lbParamSymbols.visible := true;
 fmParamList.lbParamNames.visible := false;
end;

procedure TFmParamList.rbParameterNameClick(Sender: TObject);
begin
 // make sure the names box is on top
 fmParamList.lbParamSymbols.visible := false;
 fmParamList.lbParamNames.visible := true;
end;

procedure TFmParamList.lbParamSymbolsClick(Sender: TObject);
begin
 // to always have the same name and symbol selected
 lbParamNames.itemIndex := lbParamSymbols.itemIndex;
end;

procedure TFmParamList.lbParamNamesClick(Sender: TObject);
begin
 // to always have the same name and symbol selected
 lbParamSymbols.itemIndex := lbParamNames.itemIndex;
end;

end.
